#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Georgia,8" fontscale 1

set title font "Georgia:Bold,10" noenhanced
set xlabel font "Georgia:Bold,8" noenhanced
set ylabel font "Georgia:Bold,8" noenhanced
set tics out nomirror font "Georgia,6"
set key outside right center spacing 1.25 font "Georgia,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set output "all_plots.pdf"

set title "Properties of Saturated Oxygen"
show title

$Expt << END
#           Temp       Vap Pres (atm)        Liq Vis (cp)          Gas Vis (cp)
#  Stg       (K)        Expt     Calc        Expt     Calc        Expt      Calc
#------   --------   ------------------   ------------------   --------------------
     1      80.00      0.3000   0.3002     0.26520  0.25690     0.005900  0.006778
     2      90.00      0.9800   0.9824     0.19710  0.20253     0.006800  0.007563
     3     100.00      2.5100   2.5040     0.15040  0.15873     0.007900  0.008429
     4     110.00      5.3600   5.3558     0.11880  0.12434     0.009200  0.009435
     5     120.00     10.0900  10.0928     0.09710  0.09802     0.010800  0.010683
     6     130.00     17.2600  17.3136     0.08240  0.07823     0.012900  0.012387
     7     140.00     27.5200  27.6568     0.06960  0.06305     0.015800  0.015098
     8     142.00     30.0000  30.1596     0.06680  0.06032     0.016600  0.015881
     9     144.00     32.6400  32.8205     0.06380  0.05759     0.017500  0.016802
    10     146.00     35.4500  35.6452     0.06070  0.05480     0.018500  0.017909
    11     148.00     38.4400  38.6400     0.05740  0.05186     0.019700  0.019284
    12     150.00     41.6100  41.8109     0.05370  0.04858     0.021100  0.021077
    13     152.00     45.0000  45.1643     0.04940  0.04460     0.023100  0.023628
    14     154.00     48.6500  48.7069     0.04240  0.03849     0.026900  0.028343
END
set xlabel "Temperature (K)"
set ylabel "Vapor Pressure (atm)"
plot [*:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
plot [*:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
plot [*:*][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"

set output
